/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateMicromissileSettings {
    private final float topSpeed;
    private final float accel;
    private final float damage;
    private final PointXY point;
    private final String entityFilter;
    private final MicromissilesItem.FireMode fireMode;
    private final boolean saveDefault;
    private final InteractionHand hand;

    public PacketUpdateMicromissileSettings(float topSpeed, float accel, float damage, PointXY point, String entityFilter, MicromissilesItem.FireMode fireMode, boolean saveDefault, InteractionHand hand) {
        this.topSpeed = topSpeed;
        this.accel = accel;
        this.damage = damage;
        this.point = point;
        this.entityFilter = entityFilter;
        this.fireMode = fireMode;
        this.saveDefault = saveDefault;
        this.hand = hand;
    }

    PacketUpdateMicromissileSettings(FriendlyByteBuf buffer) {
        this.topSpeed = buffer.readFloat();
        this.accel = buffer.readFloat();
        this.damage = buffer.readFloat();
        this.point = new PointXY(buffer.readInt(), buffer.readInt());
        this.entityFilter = buffer.m_130136_(Short.MAX_VALUE);
        this.fireMode = MicromissilesItem.FireMode.values()[buffer.readByte()];
        this.saveDefault = buffer.readBoolean();
        this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.topSpeed);
        buf.writeFloat(this.accel);
        buf.writeFloat(this.damage);
        buf.writeInt(this.point.x());
        buf.writeInt(this.point.y());
        buf.m_130070_(this.entityFilter);
        buf.writeByte(this.fireMode.ordinal());
        buf.writeBoolean(this.saveDefault);
        buf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            ItemStack stack = player.m_21120_(this.hand);
            if (!stack.m_41619_()) {
                this.applySettings((Player)player, stack);
            } else {
                Log.warning("Received PacketUpdateMicromissileSettings but player does not hold a Micromissile? " + player.m_7755_(), new Object[0]);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void applySettings(Player player, ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        tag.m_128350_("turnSpeed", this.accel);
        tag.m_128350_("topSpeed", this.topSpeed);
        tag.m_128350_("damage", this.damage);
        tag.m_128405_("px", this.point.x());
        tag.m_128405_("py", this.point.y());
        tag.m_128359_("filter", this.entityFilter);
        tag.m_128359_("fireMode", this.fireMode.toString());
        if (this.saveDefault) {
            MicromissileDefaults.INSTANCE.setDefaults(player, new MicromissileDefaults.Entry(this.topSpeed, this.accel, this.damage, this.point, this.entityFilter, this.fireMode));
            MicromissileDefaults.INSTANCE.tryWriteToFile();
            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, false), (ServerPlayer)player);
        }
    }
}

